%% Thomson's Multitaper Power Spectral Density (PSD) Estimate
% Martin H. Trauth 10 June 2021
%
% We first clear the workspace and the command window. We then close all
% figure windows.
clear, clc, close all

%%
% We then define the noise level, i.e. the standard deviation of the
% Gaussian noise, the sampling frequency Fs and create a time vector t.
Ns = 3;
Fs = 2;
t = 1/Fs : 1/Fs : 500; t = t';

%%
% We then create a composite signal of multiple sine waves with different
% periods T, different amplitudes A and without noise.
rng(0)
x =  2*sin(2*pi*t/50) + ...
        sin(2*pi*t/15) + ...
    0.5*sin(2*pi*t/5);

figure('Position',[100 800 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 100],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(t,x,...
    'LineWidth',1)

%%
% We can use calculate the periodogram and the Thomson's multitaper power
% spectral density using the corresponding MATLAB functions and compare
% both in two plots.
[Pxx,f] = periodogram(x,[],length(t),Fs);
[Pxxmt,fmt] = pmtm(x,1.25,length(x),Fs,'centered');

figure('Position',[100 700 800 400],...
    'Color',[1 1 1])
axes('Position',[0.1 0.1 0.35 0.8],...
    'XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On',...
    'Box','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')
title('Periodogram')
axes('Position',[0.55 0.1 0.35 0.8],...
    'XLim',[0 Fs/2],...
    'YLim',[0 max(Pxxmt)],...
    'XGrid','On',...
    'YGrid','On',...
    'Box','On'), hold on
line(fmt,Pxxmt,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power/Frequency')
title('Thomsons Multitaper Power Spectrum')

%%
% We then create a composite signal of multiple sine waves with different
% periods T, different amplitudes A and additive Gaussian noise Ns.
rng(0)
xn =  2*sin(2*pi*t/50) + ...
        sin(2*pi*t/15) + ...
    0.5*sin(2*pi*t/5) + ...
     Ns*randn(size(t));

figure('Position',[100 600 800 400],...
    'Color',[1 1 1])
axes('XLim',[0 100],...
    'XGrid','On',...
    'YGrid','On'), hold on
line(t,xn,...
    'LineWidth',1)

%%
% We can use calculate the periodogram and the Thomson's multitaper power
% spectral density using the corresponding MATLAB functions and compare
% both in two plots.
[Pxx,f] = periodogram(xn,[],length(t),Fs);
[Pxxmt,fmt] = pmtm(xn,1.25,length(xn),Fs,'centered');

figure('Position',[100 500 800 400],...
    'Color',[1 1 1])
axes('Position',[0.1 0.1 0.35 0.8],...
    'XLim',[0 Fs/2],...
    'YLim',[0 max(Pxx)],...
    'XGrid','On',...
    'YGrid','On',...
    'Box','On'), hold on
line(f,Pxx,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power Spectral Density')
title('Periodogram')
axes('Position',[0.55 0.1 0.35 0.8],...
    'XLim',[0 Fs/2],...
    'YLim',[0 max(Pxxmt)],...
    'XGrid','On',...
    'YGrid','On',...
    'Box','On'), hold on
line(fmt,Pxxmt,...
    'LineWidth',1)
xlabel('Frequency')
ylabel('Power/Frequency')
title('Thomsons Multitaper Power Spectrum')

